
#---------------------------------------------------------------------------------------#
#---------------------------------------------------------------------------------------#
# Nicholas Garvin 16 Aug 2018. Contact garvinn@rba.gov.au or nick.j.garvin@gmail.com
#    for enquiries or comments.
#
# The following code generates the figures and tables in Garvin (2018) using the
#   functions in 'Garvin (2018) tables etc FUNCTIONS.R'. Readers will not be able to run
#   the code because it is written around confidential datasets not available to the 
#   reader. 
#
# The last section of this script provides dummy examples of some of the objects used by 
#   these functions, such as the 'data.objects' list, which contains the algorithm 
#   output. That part requires reading in output generated by 'repo detection algorithm
#   RUN CODE.R'. Other objects (such as the 'iboc' dataset and the 'APRA.aggs.F' 
#   function) are not provided.
#---------------------------------------------------------------------------------------#

rm(list=ls())

# Set this to directory containing 'repo detection algorithm FUNCTIONS.R'
WDalg <- 'Z:/Writing up results/Algorithm RDP/algorithm code'
# Set this to directory containing 'Garvin (2018) tables etc RUN CODE.R'
WDfiles <- 'Z:/Writing up results/Algorithm RDP/R files'


options(warn=2)
library(igraph)
options(error=recover)

# Read in algorithm functions
setwd(WDalg)
source('repo detection algorithm FUNCTIONS.R')

# Read in functions that generate the tables and charts
setwd(WDfiles)
source('Garvin (2018) tables etc FUNCTIONS.R')
# Read in confidetnail objects not available to readers
source('Garvin (2018) confidential R objects.R')


# Years and September-dates of the eight sample windows 
years <- c(2006, 2008:2010, 2012:2015)
sepends <- c(38989, 39721, 40086, 40451, 41180, 41547, 41912, 42277)
# Shortened sample windows to avoid truncation issue at each end
trunc <- cbind(c(38975, 39706, 40071, 40436, 41167, 41532, 41897, 42262),
               c(39007, 39738, 40103, 40468, 41199, 41564, 41929, 42294))
# cashrate.csv is in the supplemetary materials
cr <- read.csv('cashrate.csv')
# int.bnds are the interest bounds used for each sample window
int.bnds <- cbind(year=years, lb=c(0.05, 0.05, 0.02, 0.035, 0.0225, 0.015, 0.015, 0.01),
                  ub=c(0.07, 0.0825, 0.0425, 0.055, 0.045, 0.035, 0.035, 0.03))


##################################################################
setwd(WDfiles)

# Generate the 'data.object' lists used for the functions below. An example of the
#   structure of these objects is at the bottom of this script (using randomly generated
#   data).
data.objects <- vector('list', length(years))
for(y in 1:length(years)) data.objects[[y]] <- 
  read.data.objects.F(years[y], int.bnds[y, 2:3], 14, 6, rbacode)
data.objects61 <- vector('list', length(years))
for(y in 1:length(years)) data.objects61[[y]] <- 
  read.data.objects.F(years[y], int.bnds[y, 2:3], 61, 6, rbacode)
fls.det.objects <- vector('list', length(years))
for(y in 1:length(years)) fls.det.objects[[y]] <- 
  read.data.objects.F(years[y], -rev(int.bnds[y, 2:3]), 14, 6, rbacode)

# Turn the algorihtm output into repo datasets. Only works if transaction cap is not 
#   above 6.
repo <- do.call(rbind, lapply(years, repo.df.F, stt, cr, 
                              data.objects, years, secprices))  

repo61 <- do.call(rbind, lapply(years, repo.df.F, stt, cr, 
                                data.objects61, years, secprices))

repo.fp <- do.call(rbind, lapply(years, repo.df.F, stt, cr, fls.det.objects, 
                                 years, secprices, neg=TRUE))

##################################################################
### --- Figure 1 --- ### Size of overnight repo and unsecured markets
###### A DUMMY OBJECT FOR IBOC IS NOT PROVIDED
write.table(outst.overnight.chart.F(repo, iboc), file='outst_overnight.csv', sep=',', 
            row.names=FALSE)
##################################################################
### --- Tables 1 and 2 --- ### Statistics on repo detection procedure; Structures of 
###   detected multiple-transaction repos
table1.14 <- do.call(cbind, lapply(years, stats.table.F, data.objects, years, 1))
colnames(table1.14) <- years
table1.14
table2.14 <- do.call(cbind, lapply(years, stats.table.F, data.objects, years, 2))
colnames(table2.14) <- years
table2.14
##################################################################
### --- Table 3 --- ### Estimating false detction rates using placebo interest bounds
table.flspos.14 <- do.call(cbind, lapply(years[3:5], table.flspos.F, repo.fp, table1.14))
table.flspos.14 <- cbind(table.flspos.14[1:3, ], 
                         round(100*c(sum(unlist(table.flspos.14[4:5, ]))/
                             sum(unlist(table.flspos.14[6:7, ])), 
                           sum(unlist(table.flspos.14[4, ]))/
                             sum(unlist(table.flspos.14[6, ])), 
                           sum(unlist(table.flspos.14[5, ]))/
                             sum(unlist(table.flspos.14[7, ]))), 2))
table.flspos.14
##################################################################
### --- Figure 2 --- ### Repo detections at placebo rates
flspos.chartdata.F(repo, repo.fp, twotr.only=TRUE, logscale=TRUE)
##################################################################
### --- Table 4 --- ### Detected repos with non-rounded simple interest rates
table.rndint.14 <- round(do.call(cbind, lapply(years, rndint.table.F, repo)), 2)
colnames(table.rndint.14) <- years
table.rndint.14 <- cbind(table.rndint.14, total=round(rndint.table.F(years, repo), 2))
rownames(table.rndint.14) <- c('total nonround', 'two transactions nonround', 
                               'multiple transactions nonround')
table.rndint.14
##################################################################
### --- Table 5 --- ### Detections with generalised repo definitions
fls.om.table <- fls.om.table.F(years, 14, 5, stt, int.bnds, icsdlabels, cr, data.objects)
cbind(fls.om.table, Total=rowSums(fls.om.table))
twoisin.repos.F(years, int.bnds, data.objects)
##################################################################
### --- Figure 3 --- ### Outstanding repos (excluding RBA) by data source
aggs <- APRA.aggs.F(c('tot'), c('rba'), years, sepends, cr)$yr.lvl
# This function also pulls out the repo data with outstanding at quarter end
repoqe <- APRA.alg.reg.F(repo61, c('tot'), c('rba'), years, sepends, repent)[[2]]
repoqe <- aggregate(cnsout ~ qes + sec, data=repoqe, sum)
aggs <- cbind(aggs, cgsalg=repoqe$cnsout[repoqe$sec == 'ags'], 
              sgsalg=repoqe$cnsout[repoqe$sec == 'sgs'], 
              othalg=repoqe$cnsout[repoqe$sec == 'oth'])
aggs[, -1] <- aggs[, -1]/1e9
aggs
##################################################################
### --- Table 6 --- ### OLS regressions of APRA data on algorithm data
cors <- cbind(cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('lnd'), 
                        years, sepends, repent, twotronly=FALSE, pos.only=FALSE), 
              cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('brw'), 
                        years, sepends, repent, twotronly=FALSE, pos.only=FALSE), 
              cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('lnd'), 
                        years, sepends, repent, twotronly=FALSE, 
                        lvl=c('entity'), pos.only=FALSE), 
              cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('brw'), 
                        years, sepends, repent, twotronly=FALSE, 
                        lvl=c('entity'), pos.only=FALSE), 
              cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('lnd'), 
                        years, sepends, repent, twotronly=FALSE, 
                        lvl=c('year'), pos.only=FALSE), 
              cor.reg.F(repo61, c('bnk', 'othADI', 'RFC', 'nonres'), c(''), 
                        c('ags', 'sgs', 'oth'), c('brw'), 
                        years, sepends, repent, twotronly=FALSE, 
                        lvl=c('year'), pos.only=FALSE))
colnames(cors) <- c('lending', 'borrowing', 'lending entity level', 
                    'borrowing entity level', 'lending year level', 
                    'borrowing year level')
rownames(cors) <- c('intercept', 'se', 'p', 'coefficient', 'se', 'p', 'p(H=1)',
                    'R sq', 'correl', 'N')
cors
##################################################################
### --- Figure 4 --- ### Outstanding repo positions
outst.chart.F(years, repo, trunc)
##################################################################
### --- Tables 7 and 8 --- ### Ten most common collateral types across full sample; 
###   Each AGS ISIN's frequency of use as collateral in 2015
issuer.table.F(repo, 10, years, data.objects)
isin.use.table.F(2015, repo, data.objects)
##################################################################
### --- Figure 5 --- ### Repo-level spreads by first-leg day and time
for(y in years) write.table(sprdtime.chart.F(y, repo, c('sprdsimp')), 
                            file=paste('sprdtime_scatter_data', y, '.csv', sep=''), 
                            sep=',', row.names=FALSE)
##################################################################
### --- Figure 6 --- ### Median repo spreads each year
annual.sprd.chart.F(years, repo, htpair)
##################################################################
### --- Figure 7 --- ### Median repo spreads by maturity
yld.crv.chart.F(repo, htpair, av=FALSE)
##################################################################
### --- Figure 8 --- ### Repo maturities by share of value
mat.share.chart.F(repo, years, trunc, htpair)
##################################################################
### --- Tables 9 and 10 and Figure 11 --- ### Generating the regression data. For use 
###   with 'Garvin (2018) regressions Stata code.do'
reg.data <- reg.vars.F(repo, years, data.objects, frn, agg=TRUE)
write.table(reg.data, file='sprdhct_regdata.csv', sep=',', row.names=FALSE)
##################################################################
### --- Figure 9 --- ### Proportion of Turnover by entity - 2015
# (Entity types only calibrated for 2015)
turnovershare.chart.F(2015, repo, stt, frn, trim.min=0.1)
##################################################################
### --- Figure 10 --- ### Network of repo positions - 2015
outst.2015 <- gross.bi.pos.F(2015, repo)
network.graph.2015.F(outst.2015)
##################################################################
### --- Figure 12 --- ### Repo-level haircuts by first-leg day and time
for(y in 2012:2015) write.table(sprdtime.chart.F(y, repo, c('hct')), 
                                file=paste('hcttime_scatter_data', y, '.csv', sep=''), 
                                sep=',', row.names=FALSE)
##################################################################
### --- Figure 13 --- ### Intraday First-leg activity - 2015
intraday.plot.F(repo, 2015, htpair)
##################################################################



##################################################################
### --- CODE FOR STATISTICS PROVIDED IN TEXT --- ### 
### EXAMINING QUARTER END ACTIVITY
qend <- -10:10
for(y in 1:8) {
  bipos <- gross.bi.pos.F(years[y], repo)
  totpos <- colSums(bipos[, 5:ncol(bipos)])/1e9
  qe <- max(which(names(totpos) <= sepends[y]))
  series <- totpos[(qe-10):(qe+10)]
  qend <- cbind(qend, series)
}
# Figure for average decline at quarter ends
decl <- rep(NA, 8)
for(c in 2:9)  decl[c-1] <- sum(qend[7:16, c])/sum(qend[2:6, c], qend[17:21, c])
mean(decl)
### PROPORTION OF POSITIVE SPREADS THAT ARE OVERNIGHT REPOS
sum(repo$mat == 1 & repo$sprdsimp > 0)/sum(repo$sprdsimp > 0)
### TURNOVER AT LONGER MATURITIES
x <- repo61[repo61$trnsno == 2, ]
x <- aggregate(cons ~ mat + year, data=x, sum)
longmats <- cbind(1:61, matrix(rep(0, 61*8), ncol=8))
for(y in 1:8) {
  z <- x[x$year == years[y], ]
  longmats[, y+1] <- z$cons[match(longmats[, 1], z$mat)]
  longmats[, y+1] <- round(100*longmats[, y+1]/sum(longmats[, y+1], na.rm=TRUE), 2)
}
longmats[is.na(longmats)] <- 0  
### LOOKING FOR REHYPOTHECATION
rehyp.F <- function(repo, twotrns=FALSE) {
  if(twotrns) repo <- repo[repo$trnsno == 2, 1:19]
  lid <- paste(repo$lnd, repo$ISIN, floor(repo$ST))  # lender/isin/day
  bid <- paste(repo$brw, repo$ISIN, floor(repo$ST))  # borrower/isin/day
  mtchs <- lapply(which(lid %in% bid),  # Find potential rehypothecation
                  function(x) c(x, which(bid == lid[x] & repo$ST > repo$ST[x])))
  mtchs <- mtchs[lapply(mtchs, length) > 1]  
  count <- lapply(1:length(mtchs), function(x) 
    mtchs[[x]][!mtchs[[x]] %in% unlist(mtchs[1:(x-1)])])  # Remove double counts
  count <- sum(unlist(lapply(count, length) > 1))
  count
}
rehyp.F(repo, TRUE)/nrow(repo)
##################################################################


##################################################################
# EXAMPLES OF DUMMY OBJECTS IN THE SAME FORMAT AS OBJECTS USED IN THE CODE ABOVE. 
#   REQUIRES FIRST RUNNING 'repo detection algorithm RUN CODE.R' TO READ THE DUMMY
#   TRANSACTIONS DATASET AND THE CORRESPONDING DUMMY REPO DATA.
load('dummy transaction and repo data.Rdata')

# Generate some dummy objects comparable to objects used in teh above code.
stt <- c('NTTY', 'QLDT', 'NSWT', 'NSWG', 'WATS', 'QLDA', 'TCVM', 'SAFA', 'WATC', 
         'TASC', 'SAFG', 'QLDG', 'ACTT')
dummy.ids.data.F <- function(trns) {
  acnt <- unique(c(trns$Snd, trns$Rec))
  name <- sample(do.call(paste0, expand.grid(LETTERS, LETTERS, LETTERS)), length(acnt))
  name[1:2] <- paste0(name[1:2], 'TR')
  name[3:5] <- paste0(name[3:5], 1)
  cbind(acnt, name)
}
dummy.sec.data.F <- function(trns, stt) {
  ISIN <- unique(trns$ISIN)
  secno <- length(ISIN)
  code <- sample(do.call(paste0, expand.grid(LETTERS, LETTERS)), secno)
  code <- paste0(code, code)
  code[1:(secno/3)] <- 'COMM'
  code[(secno/3):(2*secno/3)] <- sample(stt, length((secno/3):(2*secno/3)), replace=TRUE)
  subclass <- rep(NA, secno)
  subclass[code == 'COMM'] <- sample(c('TB', 'TN', 'TI'), sum(code == 'COMM'), 
                                     replace=TRUE)
  subclass[code != 'COMM'] <- 'CB'
  cbind(ISIN=as.character(ISIN), code, subclass)
}
dummy.omo.data.F <- function(trns, obs) {
  SD <- sample(floor(trns$ST), obs, replace=TRUE)
  Snd <- sample(trns$Snd, obs, replace=TRUE)
  Cons <- runif(obs, min=2e6, max=2e9)
  data.frame(SD, Snd, Cons)
  
}
dummy.sec.prices.F <- function(trns) {
  AsAt <- unique(floor(trns$ST))
  ISIN <- unique(trns$ISIN)
  AI <- expand.grid(AsAt, ISIN)
  sec.prices <- data.frame(AsAt=AI[, 1], ISIN=AI[, 2], 
                           PriceMid=runif(nrow(AI), 100, 120))
  sec.prices
}
# This replicates one element (i.e. one sample window/year) of the data.objects list.
data.objects <- list(alg.output, dummy.ids.data.F(trns.data), 
                     dummy.sec.data.F(trns.data, stt), dummy.omo.data.F(trns.data, 400))
# Repeat it multiple times to replicate the format of the data.objects list used above,
#   which contains 8 elements corresponding to each of the sample windows.
data.objects <- list(data.objects, data.objects, data.objects, data.objects, 
                     data.objects, data.objects, data.objects, data.objects)
# Character vector of foreign entities' ids
frn  <- sample(data.objects[[2]][nchar(data.objects[[2]][, 'name']) == 3, 'name'], 2)
# Character vector of ICSD entities' ids
icsdlabels <- sample(data.objects[[2]][grepl(1, data.objects[[2]][, 'name']), 'name'], 2)
# Character vector of high turnover borrower lender pair
htpair <- sample(data.objects[[2]][nchar(data.objects[[2]][, 'name']) == 3, 'name'], 2)
htpair <- c(lnd=htpair[1], brw=htpair[2])

